@ECHO OFF
REM ************************************************************
REM @file  start-nginx-php.cmd
REM @brief Script to run PHP-CGI and Nginx
REM
REM multiOTP - Strong two-factor authentication PHP class package
REM https://www\.multiOTP.net
REM 
REM Windows batch file for Windows 2K/XP/2003/7/2008/8/2012/10
REM
REM @author    Andre Liechti, SysCo systemes de communication sa, <info@multiotp.net>
REM @version   5.10.0.4
REM @date      2025-11-04
REM @since     2013-08-09
REM @copyright (c) 2013-2025 SysCo systemes de communication sa
REM @copyright GNU Lesser General Public License
REM
REM
REM Description
REM
REM   start-nginx-php.cmd is a small script that will start
REM   PHP-CGI and Nginx.
REM   (http://nginx.org/en/)
REM
REM
REM Licence
REM
REM   Copyright (c) 2013-2025 SysCo systemes de communication sa
REM   SysCo (tm) is a trademark of SysCo systemes de communication sa
REM   (http://www.sysco.ch/)
REM   All rights reserved.
REM
REM   This file is part of the multiOTP project.
REM
REM
REM Change Log
REM
REM   2023-12-03 5.9.7.1 SysCo/al nginx updated
REM   2017-01-10 5.0.3.3 SysCo/al Initial release
REM
REM ************************************************************

ECHO multiOTP Web Service started
ECHO.

SET _folder=%~d0%~p0

%~d0
CD %_folder%

IF NOT EXIST "%_folder%logs" MD "%_folder%logs"

START /b CMD /k ""%_folder%php\php-cgi.exe" -b 127.0.0.1:9000 -c "%_folder%php\php.ini""

REM START /b CMD /k "%_folder%nginx.exe"
REM START /b nginx.exe

"%_folder%nginx.exe"

REM taskkill /f /IM nginx.exe >NUL
REM taskkill /f /IM php-cgi.exe >NUL

REM "%_folder%nginx.exe" -s quit
